(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     17701,        469]
NotebookOptionsPosition[     17176,        447]
NotebookOutlinePosition[     17519,        462]
CellTagsIndexPosition[     17476,        459]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"x_", ",", "M_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"1", "/", "2"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"2", "/", "\[Pi]"}], ")"}], 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "n"}], "-", "1"}], ")"}]}], ")"}], " ", 
        RowBox[{"Sin", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "n"}], "-", "1"}], ")"}], "\[Pi]", " ", "x"}], 
         "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1", ",", "M"}], "}"}]}], "]"}]}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"g", "[", 
    RowBox[{"x_", ",", "M_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"1", "/", "2"}], "-", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"4", "/", 
       RowBox[{"\[Pi]", "^", "2"}]}], ")"}], 
     RowBox[{"Sum", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "/", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "n"}], "-", "1"}], ")"}], "^", "2"}]}], ")"}], " ", 
        RowBox[{"Cos", "[", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "n"}], "-", "1"}], ")"}], "\[Pi]", " ", "x"}], 
         "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"n", ",", "1", ",", "M"}], "}"}]}], "]"}]}]}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.7021207674041233`*^9, 3.702120767405624*^9}, {
  3.7021208140971317`*^9, 3.7021208297783194`*^9}, {3.7021208708839583`*^9, 
  3.702120875400344*^9}, {3.7021209348583655`*^9, 3.702120939193447*^9}, {
  3.7021209780105267`*^9, 3.7021210057218885`*^9}, {3.702134616362409*^9, 
  3.7021346774284124`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "n"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.2"}], ",", "1.2"}], "}"}]}], "}"}]}]}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{"1", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{"1.09", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Pink", ",", 
          RowBox[{"Opacity", "[", "P", "]"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{".91", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Pink", ",", 
          RowBox[{"Opacity", "[", "P", "]"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{"0", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{"0.09", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Pink", ",", 
          RowBox[{"Opacity", "[", "P", "]"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"-", ".09"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Pink", ",", 
          RowBox[{"Opacity", "[", "P", "]"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"Style", "[", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"t", ",", "0.5"}], "}"}], ",", "Green"}], "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", 
           RowBox[{"-", "4"}], ",", "4", ",", "1"}], "}"}]}], "]"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"PointSize", "[", "Large", "]"}]}]}], "]"}]}], "]"}], 
   "\[IndentingNewLine]", ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "100", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"P", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.702120799641841*^9, 3.702120799641841*^9}, {
  3.702121023977015*^9, 3.7021211198006973`*^9}, {3.7021213314245377`*^9, 
  3.7021213362327547`*^9}, {3.702121384369814*^9, 3.702121466692773*^9}, {
  3.70212158969814*^9, 3.702121612874067*^9}, {3.702121668828041*^9, 
  3.7021216933958454`*^9}, {3.7021217724713354`*^9, 3.7021217835745535`*^9}, {
  3.702121933452639*^9, 3.702121950202135*^9}, {3.702122055224174*^9, 
  3.702122060598562*^9}, {3.702122099868005*^9, 3.7021221527919145`*^9}, {
  3.702122205422222*^9, 3.702122225695242*^9}, {3.702122317287442*^9, 
  3.7021223178463945`*^9}, {3.702135111432973*^9, 3.7021351264417953`*^9}, {
  3.702135162295184*^9, 3.702135169250671*^9}, {3.7021352109722943`*^9, 
  3.702135239523695*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 1, $CellContext`P$$ = 0, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 100, 1}, {{
       Hold[$CellContext`P$$], 0}, {0, 1}}}, Typeset`size$$ = {
    360., {113., 117.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$120915$$ = 
    0, $CellContext`P$120916$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`n$$ = 1, $CellContext`P$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$120915$$, 0], 
        Hold[$CellContext`P$$, $CellContext`P$120916$$, False]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        Plot[
         $CellContext`f[$CellContext`x, $CellContext`n$$], {$CellContext`x, \
-4, 4}, PlotRange -> {{-4, 4}, {-0.2, 1.2}}], 
        Plot[1, {$CellContext`x, -4, 4}, PlotStyle -> Red], 
        Plot[1.09, {$CellContext`x, -4, 4}, PlotStyle -> {Pink, 
           Opacity[$CellContext`P$$]}], 
        Plot[0.91, {$CellContext`x, -4, 4}, PlotStyle -> {Pink, 
           Opacity[$CellContext`P$$]}], 
        Plot[0, {$CellContext`x, -4, 4}, PlotStyle -> Red], 
        Plot[0.09, {$CellContext`x, -4, 4}, PlotStyle -> {Pink, 
           Opacity[$CellContext`P$$]}], 
        Plot[-0.09, {$CellContext`x, -4, 4}, PlotStyle -> {Pink, 
           Opacity[$CellContext`P$$]}], 
        ListPlot[
         Table[
          Style[{$CellContext`t, 0.5}, Green], {$CellContext`t, -4, 4, 1}], 
         PlotStyle -> PointSize[Large]]], 
      "Specifications" :> {{$CellContext`n$$, 1, 100, 
         1}, {{$CellContext`P$$, 0}, {0, 1}}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{411., {167., 174.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.7021216136178527`*^9, 3.7021216945536275`*^9, 
  3.7021217851748257`*^9, 3.7021221555074673`*^9, 3.7021222266712303`*^9, 
  3.7021223185007224`*^9, 3.7021351719311333`*^9, 3.702135242391717*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"g", "[", 
        RowBox[{"x", ",", "n"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"-", "0.2"}], ",", "1.2"}], "}"}]}], "}"}]}]}], "]"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"-", "2"}], "-", "x"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "3"}], ",", 
         RowBox[{"-", "2"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"x", "+", "2"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "2"}], ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"-", "x"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "0"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{"x", ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "0", ",", "1"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"2", "-", "x"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "1", ",", "2"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"x", "-", "2"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", "2", ",", "3"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Red", ",", 
          RowBox[{"Opacity", "[", "0.5", "]"}]}], "}"}]}]}], "]"}]}], 
    "\[IndentingNewLine]", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"n", ",", "1", ",", "100", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7021347205411224`*^9, 3.7021347206206427`*^9}, {
  3.702134759332593*^9, 3.7021349441267176`*^9}, {3.7021349802793446`*^9, 
  3.702135033311862*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 12, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`n$$], 1, 100, 1}}, Typeset`size$$ = {
    776., {242., 245.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$89616$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 1}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$89616$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        Plot[
         $CellContext`g[$CellContext`x, $CellContext`n$$], {$CellContext`x, \
-3, 3}, PlotRange -> {{-3, 3}, {-0.2, 1.2}}], 
        Plot[-2 - $CellContext`x, {$CellContext`x, -3, -2}, PlotStyle -> {Red, 
           Opacity[0.5]}], 
        Plot[$CellContext`x + 2, {$CellContext`x, -2, -1}, PlotStyle -> {Red, 
           Opacity[0.5]}], 
        Plot[-$CellContext`x, {$CellContext`x, -1, 0}, PlotStyle -> {Red, 
           Opacity[0.5]}], 
        Plot[$CellContext`x, {$CellContext`x, 0, 1}, PlotStyle -> {Red, 
           Opacity[0.5]}], 
        Plot[2 - $CellContext`x, {$CellContext`x, 1, 2}, PlotStyle -> {Red, 
           Opacity[0.5]}], 
        Plot[$CellContext`x - 2, {$CellContext`x, 2, 3}, PlotStyle -> {Red, 
           Opacity[0.5]}]], 
      "Specifications" :> {{$CellContext`n$$, 1, 100, 1}}, "Options" :> {}, 
      "DefaultOptions" :> {}],
     ImageSizeCache->{827., {300., 307.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Input",
 CellChangeTimes->{3.7021350765685344`*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`n$$ = 98, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`n$$], 98}, 1, 100, 1}}, Typeset`size$$ = {
    360., {113., 117.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`n$113415$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`n$$ = 98}, 
      "ControllerVariables" :> {
        Hold[$CellContext`n$$, $CellContext`n$113415$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> Show[
        Plot[
         $CellContext`g[$CellContext`x, $CellContext`n$$], {$CellContext`x, \
-3, 3}, PlotRange -> {{-3, 3}, {-0.2, 1.2}}], 
        Plot[-2 - $CellContext`x, {$CellContext`x, -3, -2}, PlotStyle -> {Red, 
           Opacity[0.5]}], 
        Plot[$CellContext`x + 2, {$CellContext`x, -2, -1}, PlotStyle -> {Red, 
           Opacity[0.5]}], 
        Plot[-$CellContext`x, {$CellContext`x, -1, 0}, PlotStyle -> {Red, 
           Opacity[0.5]}], 
        Plot[$CellContext`x, {$CellContext`x, 0, 1}, PlotStyle -> {Red, 
           Opacity[0.5]}], 
        Plot[2 - $CellContext`x, {$CellContext`x, 1, 2}, PlotStyle -> {Red, 
           Opacity[0.5]}], 
        Plot[$CellContext`x - 2, {$CellContext`x, 2, 3}, PlotStyle -> {Red, 
           Opacity[0.5]}]], 
      "Specifications" :> {{{$CellContext`n$$, 98}, 1, 100, 1}}, 
      "Options" :> {}, "DefaultOptions" :> {}],
     ImageSizeCache->{411., {158., 165.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{3.7021350768197236`*^9}]
}, Open  ]]
},
WindowSize->{1280, 941},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
FrontEndVersion->"10.2 for Microsoft Windows (64-bit) (July 29, 2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1857, 59, 52, "Input"],
Cell[CellGroupData[{
Cell[2440, 83, 4091, 109, 192, "Input"],
Cell[6534, 194, 2800, 56, 391, "Output"]
}, Open  ]],
Cell[9349, 253, 3144, 91, 172, "Input"],
Cell[CellGroupData[{
Cell[12518, 348, 2311, 47, 624, InheritFromParent],
Cell[14832, 397, 2328, 47, 373, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
